<?php
class ModelExtensionShippingChronopost extends Model {
	public function getQuote($address) {
//	public function getMethod($address, $total) {	
		$this->load->language('extension/shipping/chronopost');

		$quote_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "geo_zone ORDER BY name");
		
		foreach ($query->rows as $result) {
			if ($this->config->get('shipping_chronopost_' . $result['geo_zone_id'] . '_status')) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$result['geo_zone_id'] . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

				if ($query->num_rows) {
					$status = true;
				} else {
					$status = false;
				}
			} else {
				$status = false;
			}

			if ($status) {
				$cost = '';
				$weight = $this->cart->getWeight();

				$rates = explode(',', $this->config->get('shipping_chronopost_' . $result['geo_zone_id'] . '_rate'));

				foreach ($rates as $rate) {
					$data = explode(':', $rate);

					if ($data[0] >= $weight) {
						if (isset($data[1])) {
							$cost = $data[1];
						}

						break;
					}
				}
				
		if ($this->cart->getSubTotal() >= $this->config->get('shipping_chronopost_total')) {
			$cost = '0.00'; $cost_aff = '<b>'.$this->language->get('text_free').'</b>';
		}	else {
    $cost_aff = $this->currency->format($this->tax->calculate($cost, $this->config->get('shipping_chronopost_tax_class_id'), $this->config->get('config_tax')), $this->session->data['currency']);
    }					

				if ((string)$cost != '') {
					$quote_data['chronopost_' . $result['geo_zone_id']] = array(
						'code'         => 'chronopost.chronopost_' . $result['geo_zone_id'],
						'title'        => $result['name'] . '  (' . $this->language->get('text_weight') . ' ' . $this->weight->format($weight, $this->config->get('config_weight_class_id')) . ')',
						'cost'         => $cost,
						'tax_class_id' => $this->config->get('shipping_chronopost_tax_class_id'),
						'text'         => $cost_aff
					);
				}
			}
		}

		$method_data = array();

		if ($quote_data) {
	    $title = '<img src="catalog/view/theme/default/image/shipping_logo_chronopost.png" width="118" height="28" alt="Chronopost">';
			$method_data = array(
				'code'       => 'chronopost',
				'title'      => $title,
				'quote'      => $quote_data,
				'sort_order' => $this->config->get('shipping_chronopost_sort_order'),
				'error'      => false
			);
		}

		return $method_data;
	}
}
